IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_PED_VD_IT_RECEITA]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[EST_PED_VD_IT_RECEITA](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_PED] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[CD_MEDICO_REC] [int] NULL,
	[NR_RECEITA] [bigint] NULL,
	[DT_RECEITA] [datetime] NULL,
	[COMPRADOR_NOME] [varchar](100) NULL,
	[COMPRADOR_DOC_NUMERO] [varchar](30) NULL,
	[COMPRADOR_DOC_TIPO] [int] NULL,
	[COMPRADOR_DOC_EXPEDIDOR] [varchar](10) NULL,
	[COMPRADOR_DOC_UF] [char](2) NULL,
	[PACIENTE_NOME] [varchar](100) NULL,
	[PACIENTE_IDADE] [int] NULL,
	[PACIENTE_TP_IDADE] [int] NULL,
	[PACIENTE_SEXO] [int] NULL,
	[PACIENTE_CID] [varchar](10) NULL,
	[MEDICAMENTO_NUMERO_LOTE] [varchar](20) NULL,
	[MEDICAMENTO_RECEITA_TIPO] [int] NULL,
	[MEDICAMENTO_NUMERO_NOTIFICACAO] [varchar](10) NULL,
	[MEDICAMENTO_DATA_PRESCRICAO] [datetime] NULL,
	[MEDICANENTO_DATA_VENDA] [datetime] NULL,
	[STS_IMPORT] [int] NULL,
 CONSTRAINT [PK_EST_PED_VD_IT_RECEITA] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_PED] ASC,
	[CD_PROD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PED_VD_IT_RECEITA] ADD  CONSTRAINT [DF_EST_PED_VD_IT_RECEITA_STS_IMPORT]  DEFAULT ((0)) FOR [STS_IMPORT]

ALTER TABLE [dbo].[EST_PED_VD_IT_RECEITA]  WITH CHECK ADD  CONSTRAINT [FK_EST_PED_VD_IT_RECEITA_EST_PED_VD_IT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PED], [CD_PROD])
REFERENCES [dbo].[EST_PED_VD_IT] ([CD_EMP], [CD_FILIAL], [CD_PED], [CD_PROD])

ALTER TABLE [dbo].[EST_PED_VD_IT_RECEITA] CHECK CONSTRAINT [FK_EST_PED_VD_IT_RECEITA_EST_PED_VD_IT]
end

